/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.Date;
import intrinsic.Function;
import intrinsic.mx.controls.DateChooser;
import intrinsic.mx.controls.DateField;
import intrinsic.mx.events.CalendarLayoutChangeEvent;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;

public class DateTime extends Composite {

public DateTime (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Selection, typedListener);
	addListener (SWT.DefaultSelection, typedListener);
}

static int checkStyle (int style) {
	/*
	* Even though it is legal to create this widget
	* with scroll bars, they serve no useful purpose
	* because they do not automatically scroll the
	* widget's client area.  The fix is to clear
	* the SWT style.
	*/
	style &= ~(SWT.H_SCROLL | SWT.V_SCROLL);
	style = checkBits (style, SWT.DATE, SWT.TIME, SWT.CALENDAR, 0, 0, 0);
	return checkBits (style, SWT.MEDIUM, SWT.SHORT, SWT.LONG, 0, 0, 0);
}

protected void checkSubclass () {
}

public Point computeSize (int wHint, int hHint, boolean changed) {
	checkWidget ();
	return computeNativeSize (object, wHint, hHint, changed);
}

void createHandle () {
	if ((style & SWT.CALENDAR) != 0) {
		DateChooser widget = new DateChooser();
		widget.selectedDate = new Date();
		object = widget;
	} else {
		if ((style & SWT.TIME) != 0) {
			//TODO
			DateField widget = new DateField();
			widget.selectedDate = new Date();
			object = widget;
		}
		if ((style & SWT.DATE) != 0) {
			DateField widget = new DateField();
			widget.selectedDate = new Date();
			object = widget;
		}
	}
}

Date getDate() {
	if ((style & SWT.CALENDAR) != 0) {
		return ((DateChooser)object).selectedDate;
	} else {
		return ((DateField)object).selectedDate;		
	}
}

public int getDay () {
	checkWidget ();
	return (int)getDate ().date;
}

public int getHours () {
	checkWidget ();
	return (int)getDate ().hours;
}

public int getMinutes () {
	checkWidget ();
	return (int)getDate ().minutes;
}

public int getMonth () {
	checkWidget ();
	return (int)getDate ().month;
}

public int getSeconds () {
	checkWidget ();
	return (int)getDate ().seconds;
}

public int getYear () {
	checkWidget ();
	return (int)getDate ().fullYear;
}

void handleChange (CalendarLayoutChangeEvent event) {
	postEvent(SWT.Selection);
}

native Function handleChangeFunction ()/*{
	return handleChange__Lmx_events_CalendarLayoutChangeEvent_2;
}*/;

void hookEvents() {
	super.hookEvents();
	object.addEventListener(CalendarLayoutChangeEvent.CHANGE, handleChangeFunction ());
}

public void removeSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (eventTable == null) return;
	eventTable.unhook (SWT.Selection, listener);
	eventTable.unhook (SWT.DefaultSelection, listener);	
}

void setDate (Date date) {
	if ((style & SWT.CALENDAR) != 0) {
		((DateChooser)object).selectedDate = date;
	} else {
		((DateField)object).selectedDate = date;		
	}
}

public void setDay (int day) {
	checkWidget ();
	Date date = getDate();
	date.date = day;
	setDate (date);
}

public void setHours (int hours) {
	checkWidget ();
	Date date = getDate();
	date.hours = hours;
	setDate (date);
}

public void setMinutes (int minutes) {
	checkWidget ();
	Date date = getDate();
	date.minutes = minutes;
	setDate (date);
}

public void setMonth (int month) {
	checkWidget ();
	Date date = getDate();
	date.month = month;
	setDate (date);
}

public void setSeconds (int seconds) {
	checkWidget ();
	Date date = getDate();
	date.seconds = seconds;
	setDate (date);
}

public void setYear (int year) {
	checkWidget ();
	Date date = getDate();
	date.fullYear = year;
	setDate (date);
}

}
